/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.dropseqrna.utils.readiterators;

import htsjdk.samtools.SAMRecord;
import java.util.Iterator;
import org.broadinstitute.dropseqrna.utils.FilteredIterator;

public class EditDistanceFilteringIterator
extends FilteredIterator<SAMRecord> {
    private Integer maxEditDistance;
    private static final String EDIT_DISTANCE_TAG = "NM";

    public EditDistanceFilteringIterator(Iterator<SAMRecord> underlyingIterator, Integer maxEditDistance) {
        super(underlyingIterator);
        this.maxEditDistance = maxEditDistance;
    }

    @Override
    public boolean filterOut(SAMRecord r) {
        if (this.maxEditDistance == null) {
            return false;
        }
        Object o = r.getAttribute(EDIT_DISTANCE_TAG);
        if (o == null) {
            return false;
        }
        int readEditDistance = (Integer)o;
        return readEditDistance > this.maxEditDistance;
    }
}

