/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.simpleframework.xml.stream.InputElement;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.InputStack;

class NodeReader {
    private final XMLEventReader reader;
    private final InputStack stack = new InputStack();

    public NodeReader(XMLEventReader reader) {
        this.reader = reader;
    }

    public InputNode readRoot() throws Exception {
        if (this.stack.isEmpty()) {
            return this.readElement(null);
        }
        return null;
    }

    public boolean isRoot(InputNode node) {
        return this.stack.bottom() == node;
    }

    public InputNode readElement(InputNode from) throws Exception {
        if (!this.stack.isRelevant(from)) {
            return null;
        }
        XMLEvent event = this.reader.nextEvent();
        while (event != null) {
            if (event.isEndElement()) {
                if (this.stack.pop() == from) {
                    return null;
                }
            } else if (event.isStartElement()) {
                return this.readStart(from, event);
            }
            event = this.reader.nextEvent();
        }
        return null;
    }

    public InputNode readElement(InputNode from, String name) throws Exception {
        if (!this.stack.isRelevant(from)) {
            return null;
        }
        XMLEvent event = this.reader.peek();
        while (event != null) {
            if (event.isEndElement()) {
                if (this.stack.top() == from) {
                    return null;
                }
                this.stack.pop();
            } else if (event.isStartElement()) {
                if (!this.isName(event, name)) break;
                return this.readElement(from);
            }
            event = this.reader.nextEvent();
            event = this.reader.peek();
        }
        return null;
    }

    private InputNode readStart(InputNode from, XMLEvent event) throws Exception {
        StartElement start = event.asStartElement();
        InputElement input = new InputElement(from, this, start);
        return this.stack.push(input);
    }

    private boolean isName(XMLEvent node, String name) {
        StartElement start = node.asStartElement();
        String local = start.getName().getLocalPart();
        return local.equals(name);
    }

    public String readValue(InputNode from) throws Exception {
        StringBuilder value = new StringBuilder();
        while (this.stack.top() == from) {
            XMLEvent event = this.reader.peek();
            if (!event.isCharacters()) {
                if (value.length() == 0) {
                    return null;
                }
                return value.toString();
            }
            Characters text = event.asCharacters();
            String data = text.getData();
            value.append(data);
            this.reader.nextEvent();
        }
        return null;
    }

    public boolean isEmpty(InputNode from) throws Exception {
        XMLEvent event;
        return this.stack.top() == from && (event = this.reader.peek()).isEndElement();
    }

    public void skipElement(InputNode from) throws Exception {
        while (this.readElement(from) != null) {
        }
    }
}

